package gov.va.vinci.dart.json;

import java.util.ArrayList;
import java.util.List;

import javax.validation.constraints.Min;

public class SaveRequestDataSourcesView {

	@Min(0)
	private int userId;
	
	@Min(0)
	private int requestId;
	
	//currently not exposing start/end dates and geographic location on the UI
	private String locationName;
	private String startDate;
	private String endDate;
	
	private boolean hipaaAuth;
	private boolean hipaaWaiver;

	private boolean dataMart;
	private boolean localServer;
	
	private String localServerLocation;	//facility name	
	private String localServerAddress;
	private String localServerBuilding;
	private String localServerRoomNumber;

    private boolean transferredExternal;
    private String externalDestination; // Company or Agency name
    private String externalStreet;
    private String externalCity;
    private String externalState;
    private String externalZipCode;
	
	private List<Integer> dataSources = new ArrayList<Integer>();

	private boolean realSSNIdentifier = false;
	private boolean scrambledSSNIdentifier = false;
	private boolean phiDataIdentifier = false;

	
	private boolean movingToDocsPage = false;	//need to update the documents (linear movement)
	
	
	public int getUserId() {
		return userId;
	}

	public void setUserId(int userId) {
		this.userId = userId;
	}

	public int getRequestId() {
		return requestId;
	}

	public void setRequestId(int requestId) {
		this.requestId = requestId;
	}

	public String getLocationName() {
		return locationName;
	}

	public void setLocationName(String locationName) {
		this.locationName = locationName;
	}

	public String getStartDate() {
		return startDate;
	}

	public void setStartDate(String startDate) {
		this.startDate = startDate;
	}

	public String getEndDate() {
		return endDate;
	}

	public void setEndDate(String endDate) {
		this.endDate = endDate;
	}

	public boolean isHipaaAuth() {
		return hipaaAuth;
	}

	public void setHipaaAuth(boolean hipaaAuth) {
		this.hipaaAuth = hipaaAuth;
	}

	public boolean isHipaaWaiver() {
		return hipaaWaiver;
	}

	public void setHipaaWaiver(boolean hipaaWaiver) {
		this.hipaaWaiver = hipaaWaiver;
	}

	public List<Integer> getDataSources() {
		return dataSources;
	}

	public boolean isDataMart() {
		return dataMart;
	}

	public void setDataMart(boolean dataMart) {
		this.dataMart = dataMart;
	}

	public boolean isLocalServer() {
		return localServer;
	}

	public void setLocalServer(boolean localServer) {
		this.localServer = localServer;
	}

	public String getLocalServerLocation() {
		return localServerLocation;
	}

	public void setLocalServerLocation(String localServerLocation) {
		this.localServerLocation = localServerLocation;
	}
	

	public String getLocalServerAddress() {
		return localServerAddress;
	}

	public void setLocalServerAddress(String localServerAddress) {
		this.localServerAddress = localServerAddress;
	}

	public String getLocalServerBuilding() {
		return localServerBuilding;
	}

	public void setLocalServerBuilding(String localServerBuilding) {
		this.localServerBuilding = localServerBuilding;
	}

	public String getLocalServerRoomNumber() {
		return localServerRoomNumber;
	}

	public void setLocalServerRoomNumber(String localServerRoomNumber) {
		this.localServerRoomNumber = localServerRoomNumber;
	}


    public boolean isTransferredExternal() { return transferredExternal; }

    public void setTransferredExternal(boolean transferredExternal) { this.transferredExternal = transferredExternal; }

    public String getExternalDestination() { return externalDestination; }

    public void setExternalDestination(String externalDestination) { this.externalDestination = externalDestination; }

    public String getExternalStreet() { return externalStreet; }

    public void setExternalStreet(String externalStreet) { this.externalStreet = externalStreet; }

    public String getExternalCity() { return externalCity; }

    public void setExternalCity(String externalCity) { this.externalCity = externalCity; }

    public String getExternalState() { return externalState; }

    public void setExternalState(String externalState) { this.externalState = externalState; }

    public String getExternalZipCode() { return externalZipCode; }

    public void setExternalZipCode(String externalZipCode) { this.externalZipCode = externalZipCode; }


    public boolean isRealSSNIdentifier() {
		return realSSNIdentifier;
	}

	public void setRealSSNIdentifier(boolean realSSNIdentifier) {
		this.realSSNIdentifier = realSSNIdentifier;
	}

	public boolean isScrambledSSNIdentifier() {
		return scrambledSSNIdentifier;
	}

	public void setScrambledSSNIdentifier(boolean scrambledSSNIdentifier) {
		this.scrambledSSNIdentifier = scrambledSSNIdentifier;
	}

	public boolean isPhiDataIdentifier() {
		return phiDataIdentifier;
	}

	public void setPhiDataIdentifier(boolean phiDataIdentifier) {
		this.phiDataIdentifier = phiDataIdentifier;
	}	

	
	public boolean isMovingToDocsPage() {
		return movingToDocsPage;
	}

	public void setMovingToDocsPage(boolean movingToDocsPage) {
		this.movingToDocsPage = movingToDocsPage;
	}
	
}
